Ext.data.JsonP.sol_common_as_DocumentGenerator({"tagname":"class","name":"sol.common.as.DocumentGenerator","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.as.DocumentGenerator.js","href":"lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.1"],"eloas":true,"requires":["sol.common.IxUtils","sol.common.ObjectUtils","sol.common.StringUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"collectorConfig","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-collectorConfig","meta":{}},{"name":"compareFct","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-compareFct","meta":{}},{"name":"dataCollector","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-dataCollector","meta":{"required":true}},{"name":"name","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-name","meta":{"required":true}},{"name":"renderer","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-renderer","meta":{"required":true}},{"name":"rendererConfig","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-rendererConfig","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"restrictRightsToCurrentUser","tagname":"cfg","owner":"sol.common.as.DocumentGenerator","id":"cfg-restrictRightsToCurrentUser","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"initDataCollector","tagname":"method","owner":"sol.common.as.DocumentGenerator","id":"method-initDataCollector","meta":{"private":true}},{"name":"initRenderer","tagname":"method","owner":"sol.common.as.DocumentGenerator","id":"method-initRenderer","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.as.DocumentGenerator","id":"method-process","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.as.DocumentGenerator","short_doc":"Document generation. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.as.DocumentGenerator</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator' target='_blank'>lib_sol.common.as.DocumentGenerator.js</a></div></pre><div class='doc-contents'><p>Document generation.</p>\n\n<p>This class can be used to render different kinds of documents from templates.</p>\n\n<p>To be more flexible, it uses a data collector, to collect the data which can be included in the document, and a renderer to render the resulting document.</p>\n\n<h1>Data collection</h1>\n\n<p>Data collection can either be implemented with a class or with a registered function.</p>\n\n<h1>Rendering</h1>\n\n<p>For rendering a class has to be specified. This class needs to implement a <code>render</code> function which has a name and the data (result from data collector) as arguments.</p>\n\n<h1>Ordering</h1>\n\n<p>The ordering of the data, should be determined by the data collector. Anyway, there are possible scenarios (e.g. reusing a generic data collector)\nwhere it will be necessary to apply a different ordering. To accomplish this, a <a href=\"#!/api/sol.common.as.DocumentGenerator-cfg-compareFct\" rel=\"sol.common.as.DocumentGenerator-cfg-compareFct\" class=\"docClass\">compare function</a> can be implemented.\nThis function will be applied an the data collector result after the collection.\nIt will be called with two <a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">TemplateSord</a> as arguments (see <a href=\"#!/api/sol.common.as.DocumentGenerator-cfg-compareFct\" rel=\"sol.common.as.DocumentGenerator-cfg-compareFct\" class=\"docClass\">compareFct</a>).</p>\n\n<h1>Configuration</h1>\n\n<p>The configuration for the used modules has to be defined during construction of the <code>DocumentGenerator</code>.\nThe defined objects <code>collectorConfig</code> and <code>rendererConfig</code> will be handed directly to the used modules and therefor their structure is dependent on the used module.</p>\n\n<h1>Examples</h1>\n\n<p>The first example will generate a word document with the data returned by the <code>ParentDataCollector</code>:</p>\n\n<pre><code>var generator = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.as.DocumentGenerator\" rel=\"sol.common.as.DocumentGenerator\" class=\"docClass\">sol.common.as.DocumentGenerator</a>\", {\n  name: name,\n  dataCollector: \"RF_sol_pubsec_service_ParentDataCollector\",\n  renderer: \"<a href=\"#!/api/sol.common.as.renderer.Word\" rel=\"sol.common.as.renderer.Word\" class=\"docClass\">sol.common.as.renderer.Word</a>\",\n  collectorConfig: {\n    objId: me.objId,\n    returnDataDefinition: true\n  },\n  rendererConfig: {\n    objId: me.objId,\n    templateId: me.templateId\n  }\n});\nvar result = generator.process();\n</code></pre>\n\n<p>The next example will generate a PDF report with all child elements having a defined mask. The result of the data collector will be sorted using the <code>compareFct</code>:</p>\n\n<pre><code>var generator = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.common.as.DocumentGenerator\" rel=\"sol.common.as.DocumentGenerator\" class=\"docClass\">sol.common.as.DocumentGenerator</a>\", {\n  name: name,\n  dataCollector: \"<a href=\"#!/api/sol.common.ix.services.ChildrenDataCollector\" rel=\"sol.common.ix.services.ChildrenDataCollector\" class=\"docClass\">sol.common.ix.services.ChildrenDataCollector</a>\",\n  renderer: \"<a href=\"#!/api/sol.common.as.renderer.Fop\" rel=\"sol.common.as.renderer.Fop\" class=\"docClass\">sol.common.as.renderer.Fop</a>\",\n  collectorConfig: {\n    parentId: me.parentId,\n    endLevel: -1,\n    objKeys: [],\n    totalCount: 50000,\n    sordKeys: ['ownerName', 'name', 'maskName', 'maskId', 'id', 'guid', 'parentId', 'XDateIso', 'IDateIso'],\n    maskName: me.config.filingPlan.maskName,\n    formatter: \"<a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">sol.common.ObjectFormatter.TemplateSord</a>\"\n  },\n  rendererConfig: {\n    targetId: me.targetId,\n    templateId: me.templateId\n  },\n  compareFct: function (templateSord1, templateSord2) {\n    var result;\n    try {\n      result = templateSord1.objKeys.FILING_PLAN_REFERENCE.localeCompare(templateSord2.objKeys.FILING_PLAN_REFERENCE);\n    } catch (ex) {\n      result = 0;\n    }\n    return result;\n  }\n});\nvar result = generator.process();\n</code></pre>\n\n<h1>DocumentGenerator result</h1>\n\n<p>The result object is the object returned by the <code>render</code> function of the renderer.</p>\n      <p class='version-tag'>Version: <b>1.1</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-dataCollector' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-dataCollector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-dataCollector' class='name expandable'>dataCollector</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-name' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-name' class='name expandable'>name</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>The name for the document</p>\n</div><div class='long'><p>The name for the document</p>\n</div></div></div><div id='cfg-renderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-renderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-renderer' class='name expandable'>renderer</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-collectorConfig' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-collectorConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-collectorConfig' class='name expandable'>collectorConfig</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The configuration handed to the renderer module/function</p>\n</div><div class='long'><p>The configuration handed to the renderer module/function</p>\n</div></div></div><div id='cfg-compareFct' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-compareFct' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-compareFct' class='name expandable'>compareFct</a> : Function<span class=\"signature\"></span></div><div class='description'><div class='short'>Function to sort the dataCollector result. ...</div><div class='long'><p>Function to sort the <code>dataCollector</code> result.</p>\n\n<p>The function will be called with to <a href=\"#!/api/sol.common.ObjectFormatter.TemplateSord\" rel=\"sol.common.ObjectFormatter.TemplateSord\" class=\"docClass\">TemplateSord</a> objects\nand has to return <code>-1</code> if first TemplateSord is bigger then the second one, <code>1</code> in the opposite case, or <code>0</code> if they are equal.</p>\n\n<pre><code> function (templateSord1, templateSord2) {\n   return templateSord1.objKeys.FILING_PLAN_REFERENCE.localeCompare(templateSord2.objKeys.FILING_PLAN_REFERENCE);\n }\n</code></pre>\n</div></div></div><div id='cfg-rendererConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-rendererConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-rendererConfig' class='name expandable'>rendererConfig</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>The configuration handed to the renderer module</p>\n</div><div class='long'><p>The configuration handed to the renderer module</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;dataCollector&quot;, &quot;renderer&quot;, &quot;name&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-restrictRightsToCurrentUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-cfg-restrictRightsToCurrentUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-cfg-restrictRightsToCurrentUser' class='name expandable'>restrictRightsToCurrentUser</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Restricts the rights of the document to the current user</p>\n</div><div class='long'><p>Restricts the rights of the document to the current user</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-initDataCollector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-method-initDataCollector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-method-initDataCollector' class='name expandable'>initDataCollector</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initRenderer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-method-initRenderer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-method-initRenderer' class='name expandable'>initRenderer</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.DocumentGenerator'>sol.common.as.DocumentGenerator</span><br/><a href='source/lib_sol.common.as.DocumentGenerator.html#sol-common-as-DocumentGenerator-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.DocumentGenerator-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div></div></div></div></div>","meta":{"eloas":true}});